//
// (c) 2021 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0
import wesual.Stage  1.0

import wesual.module.Dashboard 1.0

MouseArea {
    id : delegate

    property bool supportsContextMenu : true
    property alias area : thumbnail.area
    property SizeInfo displaySize : Size.defaultSize()

    signal requestSelect(var area)
    signal requestEdit(var area)

    implicitHeight : displaySize.thumbnailSize(0.1).height
    implicitWidth : displaySize.thumbnailSize(0.1, 150).width

    onDoubleClicked : requestSelect(area)

    AreaThumbnail {
        id : thumbnail

        anchors.fill : parent
    }

    UiBorder {
        anchors.fill : parent
        borderWidth : 1
        color : UiColors.getColor(UiColors.Black, .1)
        style : UiBorder.Solid
    }

    UiTooltip {
        text : area.label
    }

    UiContextMenu {
        enabled : delegate.supportsContextMenu

        UiMenuItem {
            text : qsTrId("72fd25eaf2a053da")
            iconName : "visible"

            onTriggered : delegate.requestSelect(area)
        }
        UiMenuItem {
            text : qsTrId("3a9e74adbab0c8d9")
            iconName : "edit"

            onTriggered : delegate.requestEdit(area);
        }
    }
}
